/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.app.print;

import DE.siemens.ad.logo.model.EthernetConnection;
import DE.siemens.ad.logo.model.NetworkConfiguration;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.pdraw.app.print.LogoPrintable;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Vector;

public class EthernetPagePrinter
extends LogoPrintable
implements Printable {
    static int fClientRowIndex = 0;
    static int fSlaveRowIndex = 0;
    protected int fCurrentIndex = 0;
    private Vector<Integer> fIndexArr;
    private Vector<Integer> fClientTranserTableArr;
    private Vector<Integer> fSlaveTranserTableArr;
    private int fPages = -1;
    private NetworkConfiguration networkInfo;
    private Vector<EthernetConnection> fDataVector;
    private final int lineDiff = 15;
    private final int xPosBlock = 20;
    private boolean existsPage = true;

    public EthernetPagePrinter(LogoDrawing logoDrawing) {
        super(logoDrawing);
    }

    public int getPageCount(PageFormat pf, Graphics g) {
        try {
            this.fillEthernetArray(g, pf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.fPages;
    }

    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        if ((pi -= this.fFirstPageNumber) >= this.fPages) {
            return 1;
        }
        fClientRowIndex = this.fClientTranserTableArr.get(pi);
        fSlaveRowIndex = this.fSlaveTranserTableArr.get(pi);
        this.fCurrentIndex = this.fIndexArr.get(pi);
        g.setColor(Color.black);
        this.translate(g, pf, true);
        Dimension printArea = this.printFooter(g, pf, pi + this.fFirstPageNumber + 1, this.getTotalPage());
        Rectangle preClip = g.getClipBounds();
        Rectangle curClip = new Rectangle(1, 1, printArea.width, printArea.height);
        Rectangle newClip = preClip.intersection(curClip);
        if (!newClip.isEmpty()) {
            this.setClip(g, newClip, pf, false);
            this.printEthernet(g, pf);
            this.setClip(g, preClip, pf, false);
        }
        this.translate(g, pf, false);
        return 0;
    }

    public void fillEthernetArray(Graphics g, PageFormat pf) throws PrinterException {
        this.fPages = 0;
        this.fCurrentIndex = 0;
        this.fillEthernetsConn();
        do {
            this.fIndexArr.add(this.fPages, this.fCurrentIndex);
            this.fClientTranserTableArr.add(this.fPages, fClientRowIndex);
            this.fSlaveTranserTableArr.add(this.fPages, fSlaveRowIndex);
            this.printEthernet(g, pf);
            if (!this.existsPage) continue;
            ++this.fPages;
        } while (this.fCurrentIndex < this.fDataVector.size());
    }

    protected void printEthernet(Graphics g, PageFormat pf) {
        Dimension printArea = this.printFooter(g, pf, 0, 0);
        this.printEthernetInfo(g, printArea);
    }

    protected void fillEthernetsConn() {
        this.networkInfo = this.fDrawing.getWiringDiagram().getNetworkInfo();
        this.fDataVector = (Vector)Util.deepCopy(this.networkInfo.getEthernetConnections());
        this.fIndexArr = new Vector();
        this.fClientTranserTableArr = new Vector();
        this.fSlaveTranserTableArr = new Vector();
        fClientRowIndex = 0;
        fSlaveRowIndex = 0;
    }

    protected void printEthernetInfo(Graphics pg, Dimension usableDimension) {
        EthernetConnection e;
        AbstractPrintNetworkSector networksector;
        int yPos = 0;
        if (this.fCurrentIndex == 0 && fClientRowIndex == 0 && fSlaveRowIndex == 0) {
            yPos = this.printModule(pg, usableDimension);
        }
        if (yPos == 0 && this.fDataVector.size() == 0) {
            this.existsPage = false;
            return;
        }
        while (this.fDataVector.size() > this.fCurrentIndex && (networksector = this.getInstanceSector(pg, e = this.fDataVector.elementAt(this.fCurrentIndex), yPos, usableDimension)).checkSectorHeight()) {
            yPos = networksector.printSector();
        }
    }

    private AbstractPrintNetworkSector getInstanceSector(Graphics pg, EthernetConnection e, int currentY, Dimension d) {
        AbstractPrintNetworkSector ret = null;
        if (e.isNotCreateByUser()) {
            if (e.isForSlave()) {
                ret = new PrintSlaveSector(pg, e, currentY, d);
            }
        } else if (e.getRemoteTsap() != null) {
            ret = e.isClient() ? new PrintClientSector(pg, e, currentY, d) : new PrintSeverSector(pg, e, currentY, d);
        }
        return ret;
    }

    private int printModule(Graphics pg, Dimension usableDimension) {
        if ("".equals(this.networkInfo.getIPAddress()) && "".equals(this.networkInfo.getSubnetMask()) && "".equals(this.networkInfo.getGateWay())) {
            return 0;
        }
        int yPos = 15;
        pg.setFont(new Font("Dialog", 1, 12));
        pg.drawString(Language.getString("ethernet.ethernetConfigurePanel.addressPanel", "Module Address"), 20, yPos + 3);
        pg.drawLine(0, yPos + 15, usableDimension.width, yPos + 15);
        yPos += 30;
        pg.setFont(new Font("Dialog", 0, 12));
        FontMetrics metrics = pg.getFontMetrics();
        int textHeight = metrics.getHeight();
        String subnetMask = Language.getString("ethernet.ethernetConfigurePanel.subnetMask");
        int len = metrics.charsWidth(subnetMask.toCharArray(), 0, subnetMask.length());
        int xIpPos = 20 + len + 20;
        pg.drawString(Language.getString("ethernet.ethernetConfigurePanel.ipAddressPanel", "IP Address") + ": ", 20, yPos);
        pg.drawString(this.networkInfo.getIPAddress(), xIpPos, yPos);
        pg.drawString(subnetMask, 20, yPos += textHeight);
        pg.drawString(this.networkInfo.getSubnetMask(), xIpPos, yPos);
        pg.drawString(Language.getString("ethernet.ethernetConfigurePanel.gatewayMask", "Gateway:"), 20, yPos += textHeight);
        pg.drawString(this.networkInfo.getGateWay(), xIpPos, yPos);
        pg.drawLine(0, yPos += 15, usableDimension.width, yPos);
        return yPos;
    }

    class PrintClientSector
    extends AbstractPrintNetworkSector {
        private String READ;
        private String WRITE;
        int[] ColumnLen;

        PrintClientSector(Graphics pg, EthernetConnection e, int currentYpos, Dimension dim) {
            super(pg, e, currentYpos, dim);
            this.READ = Language.getString("dialog.setClock.readBtn", "Read");
            this.WRITE = Language.getString("dialog.setClock.writeBtn", "Write");
            this.ColumnLen = new int[]{20, 70, 90, 110, 110};
        }

        public boolean checkSectorHeight() {
            boolean ret = true;
            this.fpg.setFont(this.ftBold);
            int title = this.fpg.getFontMetrics().getHeight();
            int thisSectorHeight = 0;
            this.fpg.setFont(this.ftPlain);
            int textHeight = this.fpg.getFontMetrics().getHeight();
            if (fClientRowIndex == 0) {
                thisSectorHeight += title + textHeight * 6 + 15;
                thisSectorHeight += this.yPos + textHeight * 3 + 15;
            } else {
                thisSectorHeight += this.yPos + textHeight + 15;
            }
            if (thisSectorHeight > this.fd.height) {
                ret = false;
            }
            return ret;
        }

        public int printSector() {
            int textHeight = 0;
            if (fClientRowIndex == 0) {
                String ipAddress = Language.getString("ethernet.ethernetConfigurePanel.ipAddressPanel");
                this.fpg.setFont(this.ftBold);
                textHeight = this.fpg.getFontMetrics().getHeight();
                this.yPos += textHeight;
                this.printConnectName(this.clientStr);
                this.yPos += textHeight + 15;
                this.fpg.setFont(this.ftPlain);
                textHeight = this.fpg.getFontMetrics().getHeight();
                this.printLocalServer();
                this.yPos += textHeight;
                this.printTsapLocal("");
                this.yPos += textHeight;
                this.printRemoteClient();
                this.yPos += textHeight;
                this.fpg.drawString(ipAddress + ": " + this.fe.getRemoteIP(), 20 + this.indent, this.yPos);
                this.yPos += textHeight;
                this.printTsapRemote();
                this.yPos += textHeight;
                this.printKeepAlive();
                this.yPos += textHeight + 15;
                String tabTitle = Language.getString("ethernet.connectionConfigurePanel.dataTransfer");
                this.fpg.drawString(tabTitle, 20, this.yPos);
            }
            Object[] title = this.initializeColumn();
            if (fClientRowIndex == 0 || this.yPos == 0 && EthernetPagePrinter.this.fPages > 1) {
                this.yPos += 3;
                this.generateRow(title);
            }
            int id = fClientRowIndex + 1;
            if (fClientRowIndex < this.fe.getVMReadTransactions().size()) {
                EthernetConnection.Transfer t = this.fe.getVMReadTransactions().get(fClientRowIndex);
                this.generateRow(this.convertTransfer(t, id));
            } else {
                EthernetConnection.Transfer t = this.fe.getVMWriteTransactions().get(fClientRowIndex - this.fe.getVMReadTransactions().size());
                this.generateRow(this.convertTransfer(t, id));
            }
            if (++fClientRowIndex == this.fe.getVMWriteTransactions().size() + this.fe.getVMReadTransactions().size()) {
                this.yPos += 15;
                this.fpg.drawLine(0, this.yPos, this.fd.width, this.yPos);
                fClientRowIndex = 0;
                ++EthernetPagePrinter.this.fCurrentIndex;
            }
            return this.yPos;
        }

        private Object[] initializeColumn() {
            String titleId = Language.getString("panel.tablePanel.ID");
            String titleOp = Language.getString("ethernet.ethernetConfigurePanel.dataTransfer.operate");
            String titleLen = Language.getString("ethernet.ethernetConfigurePanel.dataTransfer.length");
            String titleLocAdd = Language.getString("ethernet.ethernetConfigurePanel.dataTransfer.localAddress");
            String titleRemAdd = Language.getString("ethernet.ethernetConfigurePanel.dataTransfer.remoteAddress");
            FontMetrics metrics = this.fpg.getFontMetrics();
            Object[] title = new Object[]{titleId, titleOp, titleLen, titleLocAdd, titleRemAdd};
            for (int i = 1; i < title.length; ++i) {
                int len = metrics.charsWidth(((String)title[i]).toCharArray(), 0, ((String)title[i]).length());
                this.ColumnLen[i] = len + 20;
            }
            return title;
        }

        private Object[] convertTransfer(EthernetConnection.Transfer transferAction, int index) {
            String remoteDataTypeName = Global.getDataTypeName(transferAction.fRemoteDataBlockType);
            String remoteAdd = remoteDataTypeName.equals("DB") ? remoteDataTypeName + transferAction.fBlockAddress + ".DBB" + transferAction.fBlockByteAddress : remoteDataTypeName + transferAction.fRemoteAddress;
            Object[] rowData = new Object[]{String.valueOf(index), this.getOperateName(transferAction.fOperateCode), String.valueOf(transferAction.fLength), Global.getDataTypeName(transferAction.fLocalDataBlockType) + transferAction.fLocalAddress, remoteAdd};
            return rowData;
        }

        private String getOperateName(int operateType) {
            if (operateType == 0) {
                return this.READ;
            }
            return this.WRITE;
        }

        private void generateRow(Object[] row) {
            int currenttextX = 20;
            int cellHeight = 25;
            int cellTextX = 15;
            int cellTextY = 18;
            this.fpg.drawLine(20, this.yPos, 20, this.yPos + cellHeight);
            currenttextX = 20 + cellTextX;
            this.fpg.drawString((String)row[0], currenttextX, this.yPos + cellTextY);
            this.fpg.drawLine(currenttextX += this.ColumnLen[0], this.yPos, currenttextX, this.yPos + cellHeight);
            this.fpg.drawString((String)row[1], currenttextX += cellTextX, this.yPos + cellTextY);
            this.fpg.drawLine(currenttextX += this.ColumnLen[1], this.yPos, currenttextX, this.yPos + cellHeight);
            this.fpg.drawString((String)row[2], currenttextX += cellTextX, this.yPos + cellTextY);
            this.fpg.drawLine(currenttextX += this.ColumnLen[2], this.yPos, currenttextX, this.yPos + cellHeight);
            this.fpg.drawString((String)row[3], currenttextX += cellTextX, this.yPos + cellTextY);
            this.fpg.drawLine(currenttextX += this.ColumnLen[3], this.yPos, currenttextX, this.yPos + cellHeight);
            this.fpg.drawString((String)row[4], currenttextX += cellTextX, this.yPos + cellTextY);
            this.fpg.drawLine(currenttextX += this.ColumnLen[4], this.yPos, currenttextX, this.yPos + cellHeight);
            this.fpg.drawLine(20, this.yPos, currenttextX, this.yPos);
            this.yPos += cellHeight;
            this.fpg.drawLine(20, this.yPos, currenttextX, this.yPos);
        }
    }

    class PrintSeverSector
    extends AbstractPrintNetworkSector {
        PrintSeverSector(Graphics pg, EthernetConnection e, int currentYpos, Dimension dim) {
            super(pg, e, currentYpos, dim);
        }

        public boolean checkSectorHeight() {
            boolean ret = true;
            this.fpg.setFont(this.ftBold);
            int title = this.fpg.getFontMetrics().getHeight();
            int thisSectorHeight = 0;
            this.fpg.setFont(this.ftPlain);
            int textHeight = this.fpg.getFontMetrics().getHeight();
            if ((thisSectorHeight += this.yPos + title + textHeight * 6 + 15) > this.fd.height) {
                ret = false;
            }
            return ret;
        }

        public int printSector() {
            int textHeight = 0;
            String op = "";
            if ("02.00".equals(this.fe.getLocalTsap())) {
                op = Language.getString("ethernet.connectionConfigurePanel.op");
            }
            String acceptAllConn = Language.getString("ethernet.connectionConfigurePanel.acceptAllRequests");
            String all = Language.getString("ethernet.connectionConfigurePanel.acceptAllRequests");
            String onlyThisConnection = Language.getString("ethernet.connectionConfigurePanel.acceptOneIP");
            this.fpg.setFont(this.ftBold);
            textHeight = this.fpg.getFontMetrics().getHeight();
            this.yPos += textHeight;
            this.printConnectName(this.serverStr);
            this.yPos += textHeight + 15;
            this.fpg.setFont(this.ftPlain);
            textHeight = this.fpg.getFontMetrics().getHeight();
            this.printLocalServer();
            this.yPos += textHeight;
            this.printTsapLocal(op);
            this.yPos += textHeight;
            String resStr = "".equals(this.fe.getAcceptedIP()) ? all : onlyThisConnection + " " + this.fe.getAcceptedIP();
            this.fpg.drawString(resStr, 20 + this.indent, this.yPos);
            this.yPos += textHeight;
            this.printRemoteClient();
            this.yPos += textHeight;
            this.printTsapRemote();
            this.yPos += textHeight;
            this.printKeepAlive();
            this.yPos += 15;
            this.fpg.drawLine(0, this.yPos, this.fd.width, this.yPos);
            ++EthernetPagePrinter.this.fCurrentIndex;
            return this.yPos;
        }
    }

    class PrintSlaveSector
    extends AbstractPrintNetworkSector {
        PrintSlaveSector(Graphics pg, EthernetConnection e, int currentYpos, Dimension dim) {
            super(pg, e, currentYpos, dim);
        }

        public boolean checkSectorHeight() {
            boolean ret = true;
            int thisSectorHeight = 0;
            this.fpg.setFont(this.ftBold);
            int textHeight = this.fpg.getFontMetrics().getHeight();
            this.fpg.setFont(this.ftPlain);
            thisSectorHeight = fSlaveRowIndex == 0 ? (thisSectorHeight += this.yPos + (textHeight += this.fpg.getFontMetrics().getHeight() + 15) + this.fpg.getFontMetrics().getHeight()) : (thisSectorHeight += this.yPos + this.fpg.getFontMetrics().getHeight());
            if (thisSectorHeight > this.fd.height) {
                ret = false;
            }
            return ret;
        }

        public int printSector() {
            String from;
            EthernetConnection.Transfer transfer;
            if (fSlaveRowIndex == 0) {
                String slaveStr = "(" + Language.getString("panel.networkNodePanel.slaveSelection") + ")";
                this.fpg.setFont(this.ftBold);
                int textHeight = this.fpg.getFontMetrics().getHeight();
                this.yPos += textHeight;
                this.fpg.drawString(this.connectName + " " + slaveStr, 20, this.yPos);
                this.fpg.setFont(this.ftPlain);
                textHeight = this.fpg.getFontMetrics().getHeight();
                this.yPos += textHeight + 15;
                String remoteAddress = Language.getString("print.ethernet.slave.remoteAddress");
                this.fpg.drawString(remoteAddress + this.fe.getRemoteIP(), 20, this.yPos);
                this.yPos += textHeight;
            }
            if (fSlaveRowIndex < this.fe.getVMReadTransactions().size()) {
                transfer = this.fe.getVMReadTransactions().get(fSlaveRowIndex);
                from = "From: " + Global.getNamePrefix(transfer.fRemoteAddress >> 8) + (transfer.fRemoteAddress & 0xFF);
                String to = " To: " + Global.getNamePrefix(transfer.fLocalAddress >> 8) + (transfer.fLocalAddress & 0xFF);
                this.fpg.drawString(from + to, 20, this.yPos);
                this.yPos += this.fpg.getFontMetrics().getHeight();
            } else {
                transfer = this.fe.getVMWriteTransactions().get(fSlaveRowIndex - this.fe.getVMReadTransactions().size());
                from = "From: " + Global.getNamePrefix(transfer.fLocalAddress >> 8) + (transfer.fLocalAddress & 0xFF);
                String to = " To: " + Global.getNamePrefix(transfer.fRemoteAddress >> 8) + (transfer.fRemoteAddress & 0xFF);
                this.fpg.drawString(from + to, 20, this.yPos);
                this.yPos += this.fpg.getFontMetrics().getHeight();
            }
            if (++fSlaveRowIndex == this.fe.getVMWriteTransactions().size() + this.fe.getVMReadTransactions().size()) {
                this.fpg.drawLine(0, this.yPos, this.fd.width, this.yPos);
                fSlaveRowIndex = 0;
                ++EthernetPagePrinter.this.fCurrentIndex;
            }
            return this.yPos;
        }
    }

    abstract class AbstractPrintNetworkSector
    implements printNetworkSector {
        Graphics fpg;
        EthernetConnection fe;
        protected Font ftBold;
        protected Font ftPlain;
        protected String connectName;
        protected int yPos;
        protected Dimension fd;
        protected String clientStr = "(" + Language.getString("ethernet.connectionConfigurePanel.client") + ")";
        protected String serverStr = "(" + Language.getString("ethernet.connectionConfigurePanel.server") + ")";
        protected String localProperties = Language.getString("ethernet.connectionConfigurePanel.localProperties");
        protected String remoteProperties = Language.getString("ethernet.connectionConfigurePanel.remoteProperties");
        protected String tsap = Language.getString("ethernet.connectionConfigurePanel.tsap");
        protected String keepAlive = Language.getString("ethernet.connectionConfigurePanel.aliveInterval");
        protected String seconds = Language.getString("ethernet.connectionConfigurePanel.timeUnit");
        protected int indent = 20;

        AbstractPrintNetworkSector(Graphics pg, EthernetConnection e, int currentYpos, Dimension dim) {
            this.fpg = pg;
            this.fe = e;
            this.yPos = currentYpos;
            this.fd = dim;
            this.ftBold = new Font("Dialog", 1, 12);
            this.ftPlain = new Font("Dialog", 0, 12);
            this.connectName = Language.getString("dialog.options.color.connection") + e.getID();
        }

        protected final void printConnectName(String param) {
            this.fpg.drawString(this.connectName + " " + param, 20, this.yPos);
        }

        protected final void printLocalServer() {
            this.fpg.drawString(this.localProperties + this.serverStr, 20, this.yPos);
        }

        protected final void printTsapLocal(String param) {
            this.fpg.drawString(this.tsap + " " + this.fe.getLocalTsap() + " " + param, 20 + this.indent, this.yPos);
        }

        protected final void printRemoteClient() {
            this.fpg.drawString(this.remoteProperties + this.clientStr, 20, this.yPos);
        }

        protected final void printTsapRemote() {
            this.fpg.drawString(this.tsap + " " + this.fe.getRemoteTsap(), 20 + this.indent, this.yPos);
        }

        protected final void printKeepAlive() {
            this.fpg.drawString(this.keepAlive + " " + this.fe.getAliveInterval() + " " + this.seconds, 20, this.yPos);
        }
    }

    static interface printNetworkSector {
        public boolean checkSectorHeight();

        public int printSector();
    }
}

